#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Wavy Grid IllusionMod01.fsh  by  incre_ment  
//https://www.shadertoy.com/view/MXd3WM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Wavy grid illusion using domain repetition.
// The illusion is the appearance of black circles at the white intersections.
// Thanks to IQ and BigWIngs for the knowledge

float PI = 3.14159256;
float TAU = 2.0*3.14159256;

float dot2( in vec2 v ) { return dot(v,v); }

float lineSeg( in vec2 p, in vec2 a, in vec2 b )
{
    b -= a; p -= a;
    return length(p - b* clamp( dot(p,b)/dot(b,b), 0., 1.) );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
   vec2 uv = ( fragCoord - .5* iResolution.xy ) /iResolution.y;
   vec3 col = vec3(0.); 
   float tt = fract(.4*iTime);
      
   // Grid Scale Factor
   uv *= 12.;
   
   // Create cell IDs
   vec2 cellID = round(uv);
   
   // Each cell goes from -.5 to .5
   uv = fract(uv + .5) - .5;
   
   // Rotation radius of point in each cell
   float rr = .25;
   
   float lineVal = 0.;
   vec2 points[9];
   float offs[9];

   // Calculate motion of current and neighboring cells.  I do all 9 here,
   // even though only 5 needed for this shader (Central + above, below, left, and right).
   int count = 0;
   for(float i = -1.; i <= 1.; i++)
   for(float j = -1.; j <= 1.; j++){  
     float offset = length(cellID + vec2(i,j));
     offs[count] = offset;
     vec2 motion = vec2(rr*cos(TAU*tt+offset),rr*sin(TAU*tt+offset));
     points[count] = vec2(i,j) + motion;
     count++;   
  
   }

   // Draw the lines to the neighboring cells.  Attempt at interpolating the line width
   // between the cells based on their offset.  Not sure I got it quite right...
   for(int i = 0; i < 9; i++){
      float glow = .085;    
      vec2 p1 = points[4];
      vec2 p2 = points[i];      
      vec2 pVec = p2 - p1;     
      float pVal = dot(normalize(pVec),uv); 
      
      float oVal = 1.3 + sin(TAU*tt + mix(offs[4], offs[i], pVal));
      
      // Only draw the horizontal and verical lines
      if(i == 1 || i == 3 || i == 5 || i == 7)
      lineVal += oVal*pow(glow/(lineSeg(uv, points[4], points[i])),3.0);    
   }   
   col += lineVal;
   fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

